/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Material *brick,
         *glass;
Mesh      mbox ,
          mball;
Vec       pos[64];

Window   window;
Slider   fog_frac,
         fog_exp ;
Text    tfog_frac,
        tfog_exp ;
/******************************************************************************/
void InitPre()
{
   App.name="Fog";
   App.flag=APP_FULL_TOGGLE;
   PakAdd("../data/engine.pak");

   D.full(true).bloom(0.8,0.6,0.3,true);
   ViewportFull.range=25;

   // hide mouse
   Ms.hide();
}
/******************************************************************************/
Bool Init()
{
   brick=Materials("../data/mtrl/brick/0.mtrl");
   glass=Materials("../data/mtrl/glass/0.mtrl");

   mbox .create(1).B(0).create( Box( 10),VTX_TX0|VTX_NRM|VTX_TNG).reverse(); // create mesh box, reverse it because it's meant to be viewed from inside
   mball.create(1).B(0).create(Ball(0.5),VTX_TX0|VTX_NRM|VTX_TNG)          ; // create mesh ball

   // set mesh materials, rendering versions and bounding boxes
   mbox .setMaterial(brick).setRender().setBox();
   mball.setMaterial(glass).setRender().setBox();

   // set random positions inside box
   REPA(pos)pos[i]=Rnd(mbox.box);

   // set camera
   Cam.at   = mbox.box.cornerLDF()/2;
   Cam.dist = 10;
   Cam.pitch=-PI_4;
   Cam.yaw  = PI_4;

   // set Sky and initial fog parameters
   Sky.set    (Vec(0.3),Vec(0.3))
      .fogFrac(0);

   // add gui fog controls
   Gui   +=window   .create(Rect_C(0,-0.75,0.9,0.34),"Fog Parameters").hide();
   window+=tfog_frac.create(Vec2(0.2,-0.08),"Fraction"); window+=fog_frac.create(Rect_C(0.2+window.crect.w()/2,-0.08,0.25,0.05),Sky.fogFrac()).setDesc("Fraction of the Viewport Range where the Fog starts");
   window+=tfog_exp .create(Vec2(0.2,-0.16),"Exponent"); window+=fog_exp .create(Rect_C(0.2+window.crect.w()/2,-0.16,0.25,0.05),Sky.fogExp ()).setDesc("Fog Density");

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   Gui.update();
   CamHandle(0.01,100,Ms.hidden ? CAMH_ZOOM|(Ms.b(1)?CAMH_MOVE:CAMH_ROT) : 0); // when mouse hidden operate the camera

   if(Kb.bp(KB_TAB))
   {
      Ms    .toggle               (); // toggle mouse  visibility when tab pressed
      window.visibleToggleActivate(); // toggle window visibility when tab pressed
   }

   // set fog parameters
   Sky.fogFrac(    fog_frac()    )
      .fogExp (Pow(fog_exp (),16));

   return true;
}
/******************************************************************************/
void Render()
{
   switch(Renderer())
   {
      case RM_SOLID:
         mbox.draw(MatrixIdentity);
         REPA(pos)
         {
            glass->color.v3=ColorVec(ColorHue(Flt(i)/ELMS(pos)));
            mball.draw(Matrix(pos[i]));
         }
      break;

      case RM_LIGHT:
         LightPoint(40,Vec(0,0,0)).add();
      break;
   }
}
void Draw()
{
   Renderer(Render);
   Gui.draw();
   if(Ms.hidden)D.text(0,0.9,S+"Press Tab to toggle parameters");
}
/******************************************************************************/
